/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityHobbitBartender
extends LOTREntityHobbit
implements LOTRTradeable.Bartender {
    public LOTREntityHobbitBartender(World world) {
        super(world);
        this.npcLocationName = "entity.lotr.HobbitBartender.locationName";
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.HOBBIT_BARTENDER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.HOBBIT_BARTENDER_SELL;
    }

    @Override
    protected void dropHobbitItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block9: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(10);
            switch (j) {
                case 0: 
                case 1: {
                    this.func_70099_a(LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block9;
                }
                case 2: {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl, 2 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block9;
                }
                case 3: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block9;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(LOTRMod.hobbitPipe, 1, this.field_70146_Z.nextInt(100)), 0.0f);
                    continue block9;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(LOTRMod.pipeweed, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block9;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block9;
                }
                case 9: {
                    Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeBartender);
        if (type == LOTRTradeEntries.TradeType.SELL && itemstack.func_77973_b() == LOTRMod.pipeweedLeaf) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.sellPipeweedLeaf);
        }
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "hobbit/bartender/friendly";
        }
        return "hobbit/bartender/hostile";
    }
}

